// Autor: Marin Tomic

#include <cstdio>
#include <cstring>
#include <cassert>
#include <iostream>
#include <algorithm>

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR (i, 0, n)
#define _ << " _ " <<
#define TRACE(x) cerr << #x << " = " << x << endl
#define debug(...) fprintf(stderr, __VA_ARGS__)

// #define TRACE(x)
// #define debug(...)

using namespace std;

typedef long long llint;

const int MAXN = 5010;
const int MAXM = 5010;

int n, m;
char p[MAXN][MAXM];
bool from_source[MAXM][MAXM];
bool to_sink[MAXM][MAXM];

int main(void) {
  scanf("%d%d", &n, &m);
  REP (i, n) scanf("%s", p[i]);

  REP (i, n) REP (j, m) {
    from_source[i][j] = false;
    if (p[i][j] != 'X') continue;
    if (i == 0 && j == 0) {
      from_source[i][j] = true;
      continue;
    }
    if (i > 0) from_source[i][j] |= from_source[i-1][j];
    if (j > 0) from_source[i][j] |= from_source[i][j-1];
  }

  for (int i = n-1; i >= 0; --i) {
    for (int j = m-1; j >= 0; --j) {
      to_sink[i][j] = false;
      if (p[i][j] != 'X') continue;
      if (i == n-1 && j == m-1) {
	to_sink[i][j] = true;
	continue;
      }
      if (i < n-1) to_sink[i][j] |= to_sink[i+1][j];
      if (j < m-1) to_sink[i][j] |= to_sink[i][j+1];
    }
  }

  FOR (j, 1, m-1) {
    int ans = 0;
    bool from_up = false;
    REP (i, n) {
      if (p[i][j] == 'X') {
	if ((from_up || from_source[i][j-1]) && to_sink[i][j+1]) {
	  ++ans;
	  from_up = false;
	} else {
	  from_up |= from_source[i][j-1];
	}
      } else {
	from_up = false;
      }
    }
    printf("%d\n", ans);
  }
  
  return 0;
}
